#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_WorkloadReport : BaseTest 
	{
		private BOL.WorkloadReport _testReport;
		private System.DateTime _currentDate = DateTime.Now;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this.RefreshData = false;
			}

			this._testReport = new BOL.WorkloadReport();
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.WorkloadReport testObj = new BOL.WorkloadReport();

			Assert.IsNotNull(testObj.StartDate);
			Assert.IsNotNull(testObj.EndDate);

			Assert.IsTrue(testObj.IsMultiDivisional == false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_Date_Pass()
		{
			System.DateTime dtmStart = System.DateTime.Today.AddDays(-7);
			System.DateTime dtmEnd = System.DateTime.Today.Date;

			BOL.WorkloadReport testObj = new BOL.WorkloadReport(dtmStart, dtmEnd);

			Assert.IsTrue(testObj.StartDate == dtmStart);
			Assert.IsTrue(testObj.EndDate == dtmEnd.AddHours(23).AddMinutes(59).AddSeconds(59));
			Assert.IsTrue(testObj.IsMultiDivisional == false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Date_Fail()
		{
		}

		[Test]
		public void GetMultidivisionWorkloadReport_Pass()
		{
			// Print the report for all divisions.
			this._testReport.IsMultiDivisional=true;
			this._testReport.DivisionCode = this.TestDivisionCode;

			this._testReport.StartDate=DateTime.Today.AddYears(-1);
			this._testReport.EndDate=DateTime.Today;
		
			Assert.IsTrue(this._testReport.GetDivisionWorkloadReport(true).Rows.Count>0);
		}

		[Test]
		public void GetMultidivisionWorkloadReport_Fail()
		{
			// Print the report for all divisions.
			this._testReport.IsMultiDivisional=true;
			this._testReport.DivisionCode="INVALID";
			this._testReport.StartDate=DateTime.Today.AddDays(5);
			this._testReport.EndDate=DateTime.Today;
		
			Assert.IsTrue(this._testReport.GetDivisionWorkloadReport(true).Rows.Count<1);
		}

		[Test]
		public void GetSingleDivisionWorkloadReport_Pass()
		{
			// Print the report for all divisions.
			this._testReport.IsMultiDivisional=false;
			this._testReport.DivisionCode = this.TestDivisionCode;

			this._testReport.StartDate=DateTime.Today.AddYears(-1);
			this._testReport.EndDate=DateTime.Today.AddDays(1);

			System.Guid[] workloadGuids = {DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitGuid FROM BloodUnit WHERE DivisionCode = '" + this.TestDivisionCode + "'")};

			//Generate Postive and Negative workload
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogin);
			DataTable dtTempPP = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogin, workloadGuids, Common.WorkloadTransactionType.Unit, false);
			DataTable dtTempPN = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogin, workloadGuids, Common.WorkloadTransactionType.Unit, true);

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogout);
			DataTable dtTempNP = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogout, workloadGuids, Common.WorkloadTransactionType.Unit, false);
			DataTable dtTempNN = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogout, workloadGuids, Common.WorkloadTransactionType.Unit, true);

			Common.Utility.AppendLastUpdateInformation(dtTempPP, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtTempPN, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtTempNP, Common.UpdateFunction.UnitTests);
			Common.Utility.AppendLastUpdateInformation(dtTempNN, Common.UpdateFunction.UnitTests);

			int rc = -1;
			rc = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertWorkloadEvents.StoredProcName, dtTempPP);
			Assert.AreEqual(0, rc, "+ Workload, + Multiplier");
			rc = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertWorkloadEvents.StoredProcName, dtTempPN);
			Assert.AreEqual(0, rc, "+ Workload, - Multiplier");
			rc = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertWorkloadEvents.StoredProcName, dtTempNP);
			Assert.AreEqual(0, rc, "- Workload, + Multiplier");
			rc = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertWorkloadEvents.StoredProcName, dtTempNN);
			Assert.AreEqual(0, rc, "- Workload, - Multiplier");
			
			Assert.IsTrue(this._testReport.GetDivisionWorkloadReport(true).Rows.Count>0);
		}

		[Test]
		public void GetSingleDivisionWorkloadReport_Fail()
		{
			this._testReport.StartDate=DateTime.Today.AddDays(5);
			this._testReport.EndDate=DateTime.Today;
		
			Assert.IsTrue(this._testReport.GetDivisionWorkloadReport(false).Rows.Count<1);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateReport_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateAndPrintReport_Fail()
		{
		}

	}
}
#endif
